import java.util.*;

public class SLinkedList {
	private int length = 0;
	/*private*/ Node first = null;  	// left package protected for visualization
	/*private*/ Node last = null;   	// left package protected for visualization

	/*private*/ static class Node {		// left package protected for visualization
		Object item;
		Node next;

		Node( Object o, Node n )
		{ item = o; next = n; }
	}

	public int size() {
		return length;
	}

	public boolean isEmpty() {
		return( first == null );
	}

	public boolean contains(Object o) {
		boolean found= false;
		if (first == null)
			return false;
		Node t= first;
		while (t != null) {
			if (t.item.equals(o)) {
				found= true;
				break;
			}
			t= t.next;
		}
		return found;
	}


	public void clear() {
		first = last = null;
		length = 0;
	}

	public Object removeFirst() throws NoSuchElementException {
		if ( first == null )        // if list is empty
			throw new NoSuchElementException();
		else {
			Node t = first;
			first = first.next;
			if ( first == null )    // if list had 1 element and is now empty
				last = null;
			length--;
			return t.item;
		}
	}

	public boolean remove(Object o)
	throws NoSuchElementException {

		if (first == null)		// Empty list
			throw new NoSuchElementException();
		if (first == last) 		// If only one item in list
			if (first.item.equals(o)) {
				removeFirst();
				return true;
			} else
				return false;
		// There are at least two items in the list if we're here
		if (last.item.equals(o)) {
			removeLast();
			return true;
		}
		if (first.item.equals(o)) {
			removeFirst();
			return true;
		}
		// There are at least two items in list, and neither first nor last will be removed
		// Thus, we don't have to update first or last pointers
		Node t= first.next;
		Node prev= first;
		while (t.next != null) {
			if (t.item.equals(o)) {	
				prev.next= t.next;
				length--;
				return true;
			} else {
				prev= t;
				t= t.next;
			}
		}
		return false;
	}

	public void addFirst(Object o) {
		if ( first == null ) {  	// If the list is empty
			first = new Node( o , null);
			last = first;
		} else {
			first = new Node( o, first );
		}
		length++;
	}

	public void addLast(Object o) {
		// if the list is empty
		if ( first == null ) {
			first = new Node( o, null );
			last= first;
		} else {
			last.next = new Node( o, null );
			last= last.next;
		}
		length++;
	}


	public void add(int n, Object o) {
		if (n == 0) {
			addFirst(o);
			return;
		}
		Node current = first;
		for (int i= 0; i < n-1; i++) {
			if (current == null)
				throw new IllegalArgumentException("add: list shorter than n-1");
			else
				current = current.next;
		}
		if (current == null) 
			throw new IllegalArgumentException("add: list shorter than n-1*");
		else {
			Node prevCurrent= current;
			current.next= new Node( o, current.next);
			length++;
			if (prevCurrent == last)
				last= current.next;
		}
	}

	public Object removeLast() throws NoSuchElementException {
		if (first == null)
			throw new NoSuchElementException();
		else if (first == last) {       // 1 element in list
			Node t= first;
			first= last= null;
			length= 0;
			return t.item;  }
		else {
			Node t= first;
			while (t.next != last)
				t= t.next;
			Object ret= last.item;
			last= t;
			t.next= null;
			length--;
			return ret;
		}
	}

	public void print() {
		if (first== null) {
			System.out.println("List is empty ");
			return;
		}
		Node t= first;
		System.out.println("List contains: ");
		while (t != null) {
			System.out.print(t.item + " ");
			t= t.next;
		}
		System.out.println();
		return;
	}
	public void addUnique(String name) {
		if (!contains(name))
			addLast(name);
	}
	public Node getFirst() {
		return first;
	}
	
}		
